//
//  GLFunViewController.m
//  GLFun
//
//  Created by Robert Górczyński on 11-07-24.
//

#import "GLFunViewController.h"
#import "GLFunView.h" 
#import "Constants.h" 

@implementation GLFunViewController
@synthesize colorControl; 

- (IBAction)changeColor:(id)sender { 
	UISegmentedControl *control = sender; 
	NSInteger index = [control selectedSegmentIndex]; 
	
	GLFunView *glView = (GLFunView *)self.view; 
	
	switch (index) { 
		case kRedColorTab: 
			glView.currentColor = [UIColor redColor]; 
			glView.useRandomColor = NO; 
			break; 
		case kBlueColorTab: 
			glView.currentColor = [UIColor blueColor]; 
			glView.useRandomColor = NO; 
			break; 
		case kYellowColorTab: 
			glView.currentColor = [UIColor yellowColor]; 
			glView.useRandomColor = NO; 
			break; 
		case kGreenColorTab: 
			glView.currentColor = [UIColor greenColor]; 
			glView.useRandomColor = NO; 
			break; 
		case kRandomColorTab: 
			glView.useRandomColor = YES; 
			break; 
		default: 
			break; 
    } 
} 

- (IBAction)changeShape:(id)sender { 
    UISegmentedControl *control = sender; 
    [(GLFunView *)self.view setShapeType:[control selectedSegmentIndex]]; 
    if ([control selectedSegmentIndex] == kImageShape) 
        [colorControl setHidden:YES]; 
    else 
        [colorControl setHidden:NO]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.colorControl = nil;
    [super viewDidUnload]; 
}


- (void)dealloc {
    [colorControl release]; 
    [super dealloc];
}

@end
